//DimensionsLiBatt.scad;

//Common dimensions for case for 
//Lithium battery with charger for
//Noughts and Crosses using Arduino;

//This version is 2022_10_28;

//Changes are: 
//Many changes to 2022_09_16 were wrong;
//Hopefully, this version restores 2022_08_29;

//2022_09_16: 0:
//I discovered why I've had so much 
//trouble making adjustments, 
//moving holes and edges the wrong way:
//I used the terms: "left", "right", 
//and "rear" to describe which wall 
//which hole is in;
//And...
//To make life extra difficult for myself, 
//I draw the case with the floors near 
//the bottom and the lid top on top;
//But...
//In use, the lid top is on the bottom, 
//and the walls extend upwards, 
//and the floors become ceilings;
//I've renamed the variables 
//...input... and ...output...;
//Hopefully, I'll stop making those 
//"left", "right" mistakes;
//Hopefully;

//2022_10_28: 1:
//Floors are as for 2022_08_29;

//2022_10_28: 2:
//Switch and USB holes are as for 2022_08_29;

//2022_10_28: 3:
//a:
//Increase the width of the PCB to 
//accommodate both the three screw header 
//and the two screw header together;
//Make the change for both PCBs, 
//even though needed only for 
//the SwitchOffBoard PCB;
//!!!!!!
//But leave the mounting holes 
//where they were for 2022_08_29;
//b:
//The position of the output USB connector 
//is as for 2022_08_29;

////////////////////////////////////////////

//The case is for a battery for an 
//Arduino UNO with a clone tft based on 
//the Adafruit V1 touch screen;

//It is not helpful that the Adafruit V2 
//touch screen could use a smaller case;  
//The PH9205 battery holder I prefer to use 
//needs about as much room as the 
//Adafruit V1 touch screen; 

//The case for the battery has 
//walls unexpectedly big and 
//is intended to be used upside down, 
//so that the case for the UNO fits 
//inside the walls of the battery;

//It is probably a general purpose case 
//for many projects using a UNO and a TFT
//powered by a rechargable lithium battery;

//It uses an XC4502 battery charger, 
//an XC4512 DC to DC converter 
//and an SB2308 lithium battery 
//mounted in a PH9205 battery holder;

//The SB2299 battery is tempting, 
//but advice from Jaycar is that this 
//is not compatible with the XC4502 
//battery charger, despite the claims 
//in their catalog;

//The XC4502 and the XC4512 are mounted 
//onto a small custom PCB, and that is 
//mounted onto the floor of the case;

//The PH9205 battery holder is mounted 
//directly onto the floor of the case;

//The floor is in two parts:
//A lower floor clamps an upper floor 
//between itself and the lugs on the lid,
//but does not hold the electronic components;
//The upper floor has the posts 
//to secure the electronic components;
//These posts can be drilled 
//and tapped right thru;

//Use an include statement to include 
//these definitions in appropriate 
//modules;

//Most dimensions are relatively obvious;

//I'll make my case with a relatively 
//shallow floor and a correspondingly 
//deep lid;

//The lid will enclose and extend beyond 
//the lower floor;

//The lid has three holes:
//One for the input USB connector;
//One for the output USB connector;
//One for the actuator for the On/Off switch;
//Warning!
//See discussion above of confusion that 
//arises from terms "left", "right", 
//"front", "back";

//Unlike the case for the UNO, 
//this case does not have holes 
//extending to the bottom of the wall, 
//FloorOne does not have fillers,
//and FloorTwo does not need to accommodate 
//those fillers;

Fuzz=0.010;

Whisker = 1;

WallThickness = 3; 

//The dimensions below provide ample room 
//for the walls of the lid to fit around 
//the electronic components;

//The dimensions below are derived from 
//those of the case for the UNO, 
//and must be compatible 
//with those dimensions;
WallInnerX = 86 +2*WallThickness +Whisker;
WallInnerY = 70 +2*WallThickness +Whisker;
//From prototype 2022_03_02, 
//I discovered that WallInnerZ 
//needs to be 26mm;
WallInnerZ = 26;

FloorX = WallInnerX -Whisker;   
FloorY = WallInnerY -Whisker;    
FloorZ = 4;

//The wall of the battery case must include: 
//WallInnerZ, 
//two floors of the battery case,
//one floor height for the flange,
//and one top of the battery case;
WallZ = WallInnerZ +3*FloorZ +WallThickness;

//The holes for the USB sockets 
//do not extend to the bottom 
//of the wall of the lid;

//Both holes are simple rectangles;
//They are constructed at the origin in 
//their appropriate orientation and only need 
//to be translated to their 
//appropriate positions;

//The holes have the same centerline as 
//the PCB holding the XC4502 and the XC4512;

//The hole for the input USB;

//The hole is just a hole,
//and can be of generous thickness;
USBinputX = 3*WallThickness;
USBinputY = 11;
//Was USBinputY = 8 (2022_03_02);
//
//For prototype 2022_03_02, 
//I calculated the height for the USB 
//in a clever way that was too clever;
//The value below is the explicit, 
//measured height; 
USBinputZ = 8;
//Was: USBinputZ = 8 (2022_08_29);
//Was: USBinputZ = 9 (2022_09_16);
    
//The object used to make the hole is 
//created at the origin;
//This simplifies some ...delta... 
//calculations and complicates others;
//The values below minimise the need 
//to apply adjustments within any of 
//the modules making the object 
//and its hole;
USBinputDeltaX = -WallInnerX/2;
USBinputDeltaY = 14; 
//Was: USBinputDeltaY = 14 (2022_08_29); 
//Was: USBinputDeltaY = 13 (2022_09_16); 
USBinputDeltaZ = 21;
//Was: USBinputDeltaZ = 21 (2022_08_29); 
//Was: USBinputDeltaZ = 24 (2022_03_11);

//The hole for the output USB;

USBoutputX = USBinputX;
USBoutputY = 18;
//Was USBoutputY = 15 (2022_03_02);
//
//For prototype 2022_03_02, 
//I calculated the height for the USB 
//in a clever way that was too clever;
//The value below is the explicit, 
//measured height; 
USBoutputZ = 10;
//Was: USBoutputZ = 10 (2022_08_29);
//Was: USBoutputZ = 11 (2022_09_16);

//The object used to make the hole is 
//created at the origin;
//This simplifies some ...delta... 
//calculations and complicates others;
//The values below minimise the need 
//to apply adjustments within any of 
//the modules making the object 
//and its hole;
USBoutputDeltaX = -USBinputDeltaX;
USBoutputDeltaY = USBinputDeltaY; 
USBoutputDeltaZ = 22;
//Was: USBoutputDeltaZ = 23 (2022_09_16);
//Was: USBoutputDeltaZ = 22 (2022_08_29);
//Was :USBoutputDeltaZ = 26 (2022_06_22);
//Was: USBoutputDeltaZ = 22 (2022_03_18);
//Was: USBoutputDeltaZ = 26 (2022_03_11);

/////////////////////////////////////////
//OnOff switch for switch on PCB;
/////////////////////////////////////////

//I need an On Off Switch;
//I'll probably mount it horizontally 
//on the front wall of the lid;

//The dimensions below are for the 
//Altronics switch S2070;
//The OnOff hole is in two parts:
//A simple cube to allow a sliver of 
//the PCB that supports the switch 
//to protrude through the wall;
//Another simple cube for the switch itself;

//The switch protrudes through 
//the wall of the lid;
//It does not need a rebate inside the lid;
//It does not need holes for mounting screws;

//The hole for the sliver of PCB;

OnOffHolePcbX = 19;
OnOffHolePcbY = 3*WallThickness;
OnOffHolePcbZ = 3;
//Was: OnOffHolePcbZ = 2.5;

//When the switch is mounted onto the PCB 
//the position of the hole must be precise;
//It is easier and more reliable to measure 
//the dimensions than to use 
//clever calculations;
OnOffHolePcbDeltaX = -6;
OnOffHolePcbDeltaY = WallInnerY/2 +WallThickness;
OnOffHolePcbDeltaZ = 16;

//The hole for the switch itself;

OnOffHoleSwX = 15;
OnOffHoleSwY = 3*WallThickness;
OnOffHoleSwZ = 8;
//Was: OnOffHoleSwZ = 7;

//When the switch is mounted onto the PCB 
//the position of the hole must be precise;
//It is easier and more reliable to measure 
//the dimensions than to use 
//clever calculations;
OnOffHoleSwDeltaX = -6;
OnOffHoleSwDeltaY = WallInnerY/2 +WallThickness;
OnOffHoleSwDeltaZ = 21;
//Was: OnOffHoleSwDeltaZ = 20;

//The rebates for the mechanical pins 
//at the front of the switch;

//I'll make two small rebates, 
//one for each pin;
//...W is the width of each rebate;
//...X is the distance between the rebates;
OnOffRebateW = 3;
OnOffRebateX = 12.75;
OnOffRebateY = WallThickness;
OnOffRebateZ = 4;

//It is easier and more reliable to measure 
//the dimensions than to use 
//clever calculations;
OnOffRebateDeltaX = -6;
OnOffRebateDeltaY = WallInnerY/2 +Whisker/2;
OnOffRebateDeltaZ = 13;

/////////////////////////////////////////
//OnOff switch for switch on wall;
/////////////////////////////////////////

//I need an On Off Switch;
//I'll probably mount it horizontally 
//on the front wall of the lid;

//The dimensions below are for the 
//Jaycar switch SS0852;
//This is a dpdt switch intended to be 
//fastened to the wall and to be connected 
//to discrete wires;

//The actuator for the On/Off switch 
//must fit into a suitable hole;

//The hole for the actuator;

OnOffHoleX = 8 +2*Whisker;
//Was: OnOffHoleX = 8 +Whisker (2022_03_11);    
OnOffHoleY = 3*WallThickness;
OnOffHoleZ = 5;
//Was: OnOffHoleZ = 6 (2022_03_11);    

//When the switch is connected to the PCB 
//by flexible wires, its position need 
//not be specified precisely, 
//and it can be mounted between 
//the PCB and the top of the lid;
OnOffHoleDeltaX = +14;
//Was: OnOffHoleDeltaX = -6 (2022_03_11);    
OnOffHoleDeltaY = WallInnerY/2 +WallThickness;
OnOffHoleDeltaZ = 30;
//Was: OnOffHoleDeltaZ = 34 (2022_03_18);
//Was: OnOffHoleDeltaZ = 24 (2022_03_11);    

//The rebate to make a little extra room 
//for the flange of the switch;

OnOffFlangeX = 23 +Whisker;
OnOffFlangeY = 2*WallThickness;
OnOffFlangeZ = 8 +Whisker;

OnOffFlangeDeltaX = OnOffHoleDeltaX;
OnOffFlangeDeltaY 
    = OnOffHoleDeltaY -2*WallThickness +1;

//Curiously, the calculation for the DeltaZ
//for the rebate seemed surprisingly dificult;
//I tried several clever calculations, 
//but they all became too clever;
//Then I discovered:
OnOffFlangeDeltaZ = OnOffHoleDeltaZ;

//Definitions for mounting screws;
//Ideally, I'd prefer to use 
//countersunk screws, but these seem 
//to be difficult to obtain in this 
//small size, and Jaycar recommend 
//and sell cheese head screws;
OnOffScrewPhi = 2.5;
//Was: OnOffScrewPhi = 2 (2022_03_11);    
OnOffScrewHeadPhi = 3;
OnOffScrewHeadHeight = 1;

OnOffScrewLength = 3*WallThickness;

OnOffScrewDeltaX = 19/2;

/////////////////////////////////////////
//Posts to hold floors to walls of lid;
/////////////////////////////////////////

//I need something to hold 
//the lid to the floor;
//After quite a lot of thought, 
//I decided to attach pillars to the walls 
//of the lid, put tapped holes in them, 
//and have holes in the floor for screws;  
//I'd rather keep the floor smooth and 
//clear, but I can't think of anything 
//better than holes at this time;
//The diameter of the thread is 
//a bit of a surprise;
//The screws are sold as 3mm;
//I thought I'd need a hole bigger than 3mm;
//It seems that I don't;

PostLidPhi = 5;
PostLidTapPhi = 2.5;
PostLidHeight = 6;

LidScrewHeadPhi = 6;
LidScrewHeadDepth = 2;
LidScrewThreadPhi = 3.2;

//Provided I use the same values for 
//the screw holes in the floor and the
//pillars on the walls of the lid, 
//the components should align correctly;

//The values below have been adopted 
//circa 2021_11_22, after quite a lot 
//of trial and error, especially error;  
//Earlier trials put the pillars 
//too close to the components;

//This version is 2022_03_30;
//For prototype 2022_03_11,
//I moved the posts PostLidPhi/4 towards 
//each wall;
//That is too close;
//I want to restore the DeltaY of 
//the prototype of 2022_03_02, 
//even though for prototype 2022_03_02,
//the posts on the wall near the battery 
//were still too close to the components, 
//making the floor impossible to fit 
//into the lid;
//I need to shorten the posts to keep 
//them closer to the walls;
//I'll shorten all posts, for symmetry 
//and to prempt an opportunity 
//to shorten just the posts 
//on the wrong wall;
//I'll deem PostLidPhi to be just right, 
//and displace just the holes and the cube 
//that pushes the posts away from the walls;

LidBLx = -(WallInnerX/2 -PostLidPhi);    
//For prototype 2022_03_11,
//was: LidBLx = -(WallInnerX/2 -10);    
//For prototype 2022_11_22,
//was: LidBLx = -(WallInnerX/2 -15);    
LidBLy = -(WallInnerY/2 -PostLidPhi +Fuzz);  
//For prototype 2022_03_11,
//was:  -(WallInnerY/2 +PostLidPhi/4
//     -PostLidPhi +Fuzz);
//For prototype 2022_11_22,
//was: LidBLy = 
//      -(WallInnerY/2 -PostLidPhi +Fuzz);    

LidBRx = -LidBLx;    
LidBRy = LidBLy;    

LidTRx = LidBRx;        
LidTRy = -LidBLy;    

LidTLx = LidBLx; 
LidTLy = -LidBLy;    

/////////////////////////////////////////
//Posts to hold the PCB to FloorTwo;
/////////////////////////////////////////

//There are six mounting posts, 
//two for the PH9205 battery holder 
//and four for the custom PCB 
//on which the XC4502 and XC4512 
//are mounted;

//They are numbered as implied by 
//the diagram below;

// +-------------------------------------+
// |  o1                             o2  |
// |                                     |
// |  o3                             o4  |
// |                                     |
// |          o5            o6           |
// +-------------------------------------+

//Holes 1, 2, 3, 4 
//form a rectangle 70mm x 25.4mm;
//Was 70mm x 23mm;

//Holes 5, 6 are 54mm apart;

//Warning!
//For posts 1, 2, 3, 4, 
//the definition of USBinputDeltaY 
//ensures that the USB connectors on 
//the PCB align correctly with the holes 
//in the walls;
//I must resist the temptation to meddle;
ImpToMet = 25.4/1000;
PCBy = 1000*ImpToMet;

Post1x = -70/2;    
Post1y = USBinputDeltaY +PCBy/2;     

Post2x = 70/2;    
Post2y = Post1y;    

Post3x = Post1x;        
Post3y = Post1y -PCBy;    

Post4x = Post2x; 
Post4y = Post3y;    

Post5x = -54/2;        
Post5y = -(WallInnerY/2 -22);    
//For prototype 2022_03_02,
//was: Post5y = -(WallInnerY/2 -18);    

Post6x = 54/2; 
Post6y = Post5y;    

//Each mounting post is a simple cone 
//with a hole in the middle;
PostPhiBottom = 6;
PostPhiTop = 4;
PostHeight = 4;

//All holes in the mounting posts 
//are PostTapPhi = 2.5mm, 
//ready to be tapped for a 3mm screw;
PostTapPhi = 2.5;

/////////////////////////////////////////
//Recesses for magnets to hold 
//the UNO case to the LiBattery case;
/////////////////////////////////////////

//I want to use two magnets to attach 
//the battery case to the UNO case;
//In particular: Jaycar LM1622;
//These are 10mm Phi, 3mm high;
//I want most of the hole for them in 
//FloorOne and a smaller portion of the 
//hole for them in FloorTwo;
//However, if the holes are the same size, 
//the magnet will naturally position 
//itself into FloorOne;
MagnetHolePhi = 11;
MagnetHoleHeight = 2;

//I need to define the translations 
//for the holes globally, so all holes 
//and magnets align properly;
//I'll place the magnets on the centerlines 
//of the floors, so one of MagnetHoleDeltaX 
//or MagnetHoleDeltaY will be zero; 

//Although relative definitions look 
//elegant, to ensure that the magnets in 
//the case for the UNO align with the 
//magnets in the case for the battery, 
//it is safer to define MagnetHoleDeltaX 
//and MagnetHoleDeltaY absolutely;
MagnetHoleDeltaX = 0;
MagnetHoleDeltaY = 25;

/////////////////////////////////////////
//Miscellaneous useful information;
/////////////////////////////////////////

//A subset of a chart of drill sizes 
//for tapped holes:
//Tap mm    Drill mm;
//M2        1.6;
//M2.5      2.05;
//M3        2.5;
//M4        3.3;
//M5        4.2;
//M6        5.0;

//An attractive subset of the names 
//that OpenSCAD recognizes for colours;
//I can remember "blue", but continually 
//forget the names of the others;
//Reds
//  LightCoral
//  LightSalmon
//Oranges
//  Coral
//  Orange
//Yellows
//  LemonChiffon
//Greens
//  LightGreen
//  YellowGreen
//Blues
//SkyBlue
//  CornflowerBlue
//Violets
//  Plumb
//  Violet
//Browns
//  Tan

//
//
